﻿// Copyright(C) 2025 Altom Consulting

using EpicGames.Core;
using UnrealBuildTool;
using System.IO;
using System;
using System.Collections.Generic;
using Microsoft.Extensions.Logging;

public class AltTester : ModuleRules
{
	public AltTester(ReadOnlyTargetRules Target) : base(Target)
	{
		PrivateDependencyModuleNames.AddRange(new string[]
		{
			"ApplicationCore",
			"Core",
			"CoreUObject",
			"DeveloperSettings",
			"Engine",
			"InputCore",
			"Json",
			"JsonUtilities",
			"MovieSceneCapture",
			"Projects",
			"RHI",
			"RenderCore",
			"Slate",
			"SlateCore",
			"UMG",
			"WebSockets",
			"HTTP"
		});

		if (Target.bBuildEditor)
		{
			PrivateDependencyModuleNames.Add("SubobjectDataInterface");
			PrivateDependencyModuleNames.Add("UnrealEd");
		}

		if (Target.Platform == UnrealTargetPlatform.IOS)
		{
			// Required to access the HTTP Proxy of the operating system - useful especially for BrowserStack
			PublicAdditionalFrameworks.Add(new Framework("CFNetwork", string.Empty, ""));
		}

		AddEngineThirdPartyPrivateStaticDependencies(Target, "UElibJPG");

		bUsePrecompiled = !Directory.Exists(Path.GetFullPath(Path.Combine(ModuleDirectory, "Private/")));
		if (!Target.bIsEngineInstalled && bUsePrecompiled)
		{
			Target.Logger.LogInformation("[AltTester] Detected source engine build with precompiled plugin.");

			string ProjectDirectory = Target.ProjectFile.Directory.ToString();
			string PluginBaseDirectory = Path.GetFullPath(Path.Combine(ModuleDirectory, "..", ".."));

			CopyIntermediateToProject(ProjectDirectory, PluginBaseDirectory);
		}

		string commitHash = Environment.GetEnvironmentVariable("ALTTESTER-COMMIT-HASH");
		string alttesterVersion = Environment.GetEnvironmentVariable("ALTTESTER-VERSION");
		if (string.IsNullOrEmpty(alttesterVersion))
		{
			alttesterVersion = "1.1.2";
		}

		PublicDefinitions.Add($"ALTTESTER_PLUGIN_VERSION=\"{alttesterVersion}\"");
		PublicDefinitions.Add($"ALTTESTER_COMMIT_HASH=\"{commitHash}\"");
	}

	private void CopyAllFiles(string sourceDir, string destinationDir)
	{
		Target.Logger.LogInformation($"[AltTester] Copying files from {sourceDir} to {destinationDir}");
		if (!Directory.Exists(destinationDir))
		{
			Directory.CreateDirectory(destinationDir);
		}

		foreach (string entry in Directory.EnumerateFileSystemEntries(sourceDir))
		{
			string entryName = Path.GetFileName(entry);
			string destPath = Path.Combine(destinationDir, entryName);

			if (Directory.Exists(entry))
			{
				// Entry is a subdirectory -> recurse
				CopyAllFiles(entry, destPath);
			}
			else if (File.Exists(entry))
			{
				// Entry is a file -> copy
				File.Copy(entry, destPath, overwrite: true);
			}
		}
	}

	private void CopyIntermediateToProject(string ProjectBaseDirectory, string PluginBaseDirectory)
	{
		string SourceObjIntermediateDirectory = Path.GetFullPath(Path.Combine(PluginBaseDirectory, "Intermediate/Build", Target.Platform.ToString(), Target.Architecture.ToString(), "UnrealGame"));
		string TargetObjIntermediateDirectory = Path.GetFullPath(Path.Combine(ProjectBaseDirectory, "Intermediate/Build", Target.Platform.ToString(), Target.Architecture.ToString(), "UnrealGame"));
		CopyAllFiles(SourceObjIntermediateDirectory, TargetObjIntermediateDirectory);

		string SourcePrecompiledIntermediateDirectory = Path.GetFullPath(Path.Combine(PluginBaseDirectory, "Intermediate/Build", Target.Platform.ToString(), "UnrealGame"));
		string TargetPrecompiledIntermediateDirectory = Path.GetFullPath(Path.Combine(ProjectBaseDirectory, "Intermediate/Build", Target.Platform.ToString(), Target.Name));
		CopyAllFiles(SourcePrecompiledIntermediateDirectory, TargetPrecompiledIntermediateDirectory);
	}
}
